<?php

namespace VM\ApiBundle\Controller;

use Doctrine\DBAL\LockMode;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use FOS\RestBundle\Controller\Annotations\View;
use Symfony\Component\HttpFoundation\Response;
use VM\ApiBundle\Entity\Company;
use VM\ApiBundle\Entity\CompanyAllegroCategoryItem;
use VM\ApiBundle\Entity\CompanyBankServiceOption;
use VM\ApiBundle\Entity\CompanyOfferReport;
use VM\ApiBundle\Entity\OfferReport;
use VM\ApiBundle\Exceptions\ApiException;

class ReportsController extends AbstractController
{

    /**
     * Pobiera listę dostępnych raportów stałych wraz z informacją o tym które z nich zostały zakupione
     *
     * @View(serializerGroups={"companyOfferReports"})
     */
    public function loadAction()
    {
        try
        {
            $User = $this->getUser();
            $Company = $this->getApiGetter()->getUserCompanyOrFalse($User);
            $companyOfferReports = $Company->getCompanyOfferReports();

            $boughtIds = array();
            /* @var $CompanyOfferReport CompanyOfferReport */
            foreach($companyOfferReports as $CompanyOfferReport)
            {
                $boughtIds[] = $CompanyOfferReport->getReportId();
            }

            $availableOfferReports = $User->getGroup()->getUser()->getMarketSegment()->getOfferReports();

            return array(
                'availableOfferReports' => $availableOfferReports,
                'boughtIds' => $boughtIds
            );
        }
        catch(\Exception $Exception)
        {
            throw new ApiException($Exception->getMessage(), $Exception->getCode());
        }
    }


    /**
     * Zapisuje zakup raportu stałego
     *
     * @View(serializerGroups={"companyOfferReports"})
     */
    public function buyAction()
    {
        $this->getDoctrine()->getConnection()->beginTransaction();
        try
        {
            $data = $this->getRequest()->request->getIterator()->getArrayCopy();

            $User = $this->getUser();
            $Company = $this->getApiGetter()->getUserCompanyOrFalse($User);
            $MarketSegment = $User->getGroup()->getUser()->getMarketSegment();
            $CurrentAccount = $this->getApiGetter()->getCompanyCurrentAccount($Company->getId());
            $Round = $this->getApiGetter()->getUserActualRound($User);
            $CurrentAccount = $this->getApiGetter()->getCompanyCurrentAccount($Company->getId());

            $this->getDoctrine()->getManager()->lock($CurrentAccount, LockMode::OPTIMISTIC, $CurrentAccount->getVersion());

            $OfferReport = $this->getApiGetter()->getOfferReport($data['id']);
            if($OfferReport->getMarketSegment() != $MarketSegment)
            {
                throw new \Exception('Ten raport nie dotyczy Twojego segmentu, więc nie możesz go kupić.');
            }

            if($CurrentAccount->getValue() < $OfferReport->getPrice())
            {
                throw new \Exception('Nie masz wystarczającej ilości pieniędzy do kupna tego raportu.');
            }

//            if(!$Company->getCompanyOfferReports()->contains($OfferReport))
            if(!$this->doesCompanyHaveOfferReport($Company, $OfferReport))
            {
                $CompanyOfferReport = new CompanyOfferReport();
                $CompanyOfferReport->setCompany($Company);
                $CompanyOfferReport->setRound($Round);
                $CompanyOfferReport->setReport($OfferReport);
                $this->getDoctrine()->getManager()->persist($CompanyOfferReport);

//                $Company->addCompanyOfferReport($OfferReport);

                $CurrentAccount->setValue($CurrentAccount->getValue()-$OfferReport->getPrice());
                $AccountChange = $this->getApiCreator()->createAccountChange($Round, $Company, -1 * $OfferReport->getPrice(), 'Zakup raportu - ' . $OfferReport->getName());
                $this->getDoctrine()->getManager()->persist($AccountChange);
            }

            $userSsoIds = array();
            foreach($this->getUser()->getGroup()->getUsers() as $User)
            {
                $externalId = $User->getExternalId();
                if(!empty($externalId))
                {
                    $userSsoIds[] = $externalId;
                }
            }
        }
        catch(\Exception $Exception)
        {
            $this->getDoctrine()->getConnection()->rollback();
            return new Response(json_encode(array('message' => $Exception->getMessage())), 500);

//            throw new ApiException($Exception->getMessage(), $Exception->getCode());
        }

        try
        {
            $response = $this->getAuthCommunication()->connectUsersToProduct($OfferReport->getCode(), $userSsoIds);
            if(!empty($response['error']))
            {
                throw new \Exception($response['error']['message'], $response['error']['code']);
            }

            $this->getDoctrine()->getManager()->flush();
            $this->getDoctrine()->getConnection()->commit();
        }
        catch(\Exception $Exception)
        {
            $this->getDoctrine()->getConnection()->rollback();
            return new Response(json_encode(array('message' => 'Błąd serwera autoryzacyjnego '.$Exception->getMessage())), 500);

//            throw new ApiException('Błąd serwera autoryzacyjnego '.$Exception->getMessage(), $Exception->getCode());
        }

        return true;
    }

    protected function doesCompanyHaveOfferReport(Company $Company, OfferReport $OfferReport)
    {
        $has = false;
        /* @var $CompanyOfferReport CompanyOfferReport */
        foreach($Company->getCompanyOfferReports() as $CompanyOfferReport)
        {
            if($CompanyOfferReport->getReportId() == $OfferReport->getId())
            {
                $has = true;
            }
        }
        return $has;
    }
}
